% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzID.R, R/mzIDCollection.R
\docType{class}
\name{mzID-class}
\alias{c,mzID-method}
\alias{database,mzID-method}
\alias{evidence,mzID-method}
\alias{files,mzID-method}
\alias{id,mzID-method}
\alias{idScanMap,mzID-method}
\alias{length,mzID-method}
\alias{modifications,mzID-method}
\alias{mzID-class}
\alias{parameters,mzID-method}
\alias{peptides,mzID-method}
\alias{removeDecoy,mzID-method}
\alias{scans,mzID-method}
\alias{show,mzID-method}
\alias{software,mzID-method}
\title{A class to contain data from mzIdentML-files}
\usage{
\S4method{show}{mzID}(object)

\S4method{length}{mzID}(x)

\S4method{removeDecoy}{mzID}(object)

\S4method{database}{mzID}(object, safeNames = TRUE)

\S4method{evidence}{mzID}(object, safeNames = TRUE)

\S4method{parameters}{mzID}(object)

\S4method{software}{mzID}(object)

\S4method{files}{mzID}(object)

\S4method{peptides}{mzID}(object, safeNames = TRUE)

\S4method{modifications}{mzID}(object)

\S4method{id}{mzID}(object, safeNames = TRUE)

\S4method{scans}{mzID}(object, safeNames = TRUE)

\S4method{idScanMap}{mzID}(object)

\S4method{c}{mzID}(x, y, ..., recursive = FALSE)
}
\arguments{
\item{object}{An mzID object}

\item{x}{An mzID object}

\item{safeNames}{Should column names be lowercased to ensure compatibility
between v1.0 and v1.1 files?}

\item{y}{An mzID or mzIDCollection object}

\item{...}{ignored}

\item{recursive}{ignored}
}
\description{
This class stores all parsed information from mzIdentML files
}
\details{
The mzID class stores information in a subset of classes, each class having 
its own slot. While these classes should not need to be accessed directly, 
descriptions of their content is delegated to each respective class.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Short summary of object content

\item \code{length}: Get number of psm' in object

\item \code{removeDecoy}: Remove decoys from mzID object

\item \code{database}: Get the database used for searching

\item \code{evidence}: Get the evidence from the peptide search

\item \code{parameters}: Get the parameters used for the search

\item \code{software}: Get the software used to arrive at the results

\item \code{files}: Get the data files used for the analysis

\item \code{peptides}: Get the peptides identified.

\item \code{modifications}: Get the modification on the identified peptides

\item \code{id}: Get the identification results

\item \code{scans}: Get the scans matched to peptides

\item \code{idScanMap}: Get the link between scans and identifications

\item \code{c}: Combine mzID and mzIDCollection objects
}}
\section{Slots}{

\describe{
\item{\code{parameters}}{An instance of \code{\link{mzIDparameters-class}}. This 
object contains all information related to how the analysis was carried out.}

\item{\code{psm}}{An instance of \code{\link{mzIDpsm-class}}. This object contains 
the meat of the analysis with all scans and their related PSMs recorded.}

\item{\code{peptides}}{An instance of \code{\link{mzIDpeptides-class}}. This object 
contains a library of all peptides generated from the database along with 
possible modifications.}

\item{\code{evidence}}{An instance of \code{\link{mzIDevidence-class}}. This object 
lists all peptides detected in the analysis with reference to the 
\code{mzIDpeptides} instance.}

\item{\code{database}}{An instance of \code{\link{mzIDdatabase-class}}. This object 
contains information on the proteins in the database. As the full database is
not recorded in mzIdentML files the actual protein sequence is not recorded 
but there is sufficient information to retrieve it from the database file.}
}}
\section{Objects from the class}{

Objects can be created using the \code{\link{mzID}} constructor, which 
handles parsing of mzIdentML files
}
\references{
\url{http://www.psidev.info/mzidentml}
}
\seealso{
\code{\link{mzID}}

Other mzID.classes: \code{\link{mzIDCollection-class}},
  \code{\link{mzIDdatabase-class}},
  \code{\link{mzIDevidence-class}},
  \code{\link{mzIDparameters-class}},
  \code{\link{mzIDpeptides-class}},
  \code{\link{mzIDpsm-class}}
}

