% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_functions.R
\name{getTopHits}
\alias{getTopHits}
\title{Filter QTLExperiment to keep only top hits}
\usage{
getTopHits(
  qtle,
  mode = c("global", "state"),
  assay = "pvalues",
  assaySig = "significant",
  verbose = FALSE
)
}
\arguments{
\item{qtle}{A `QTLExperiment` object}

\item{mode}{global/state to specify if the top hit per feature is desired
from across all states or for each state.}

\item{assay}{The assay containing the test statistic to minimize.}

\item{assaySig}{The assay containing TRUE/FALSE significance calls for each
QTL test.}

\item{verbose}{logical. Whether to print progress messages.}
}
\value{
A subset of the `QTLExperiment` object, with only tests that are the
top hits for each feature (`mode=global`) or for each feature for each
state (`mode=state`).
}
\description{
Method to return a subset of a \linkS4class{QTLExperiment} object containing
only the tests that are top hits. Top hits are defined as the test for each
feature with the most significant test statistic. Returns an array of the top 
QTL for each feature across all states
}
\examples{
sumstats <- mockSummaryStats(nStates=10, nQTL=100, names=TRUE)
qtle <- QTLExperiment(
    assay=list(
    betas=sumstats$betas,
    errors=sumstats$errors,
    pvalues=sumstats$pvalues,
    lfsrs=sumstats$pvalues))

# Add 'significant' assay to object
qtle <- callSignificance(qtle)

# Filter to the top tests for each feature
qtle_glob <- getTopHits(qtle, assay="lfsrs", mode="global", verbose = TRUE)
# There are 3 rows corresponding to the three features.
table(feature_id(qtle_glob))

# At most one QTL is retained for each combination of feature_id and state_id
qtle_feat <- getTopHits(qtle, assay="lfsrs", mode="state", verbose = TRUE)
table(feature_id(qtle_feat))

}
