% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_plot.R
\name{plot_karyogram}
\alias{plot_karyogram}
\title{Karyo/Interval Plot GRanges(List)}
\usage{
plot_karyogram(grlist, title = unique(genome(grlist)))
}
\arguments{
\item{grlist}{\code{\link[GenomicRanges]{GRanges-class}}}

\item{title}{plot title}
}
\value{
list
}
\description{
Karyo/Interval Plot GRanges(List)
}
\examples{
# Plot GRanges
    bedfile <-  system.file('extdata/SRF.bed',  package = 'multicrispr')
    gr <- bed_to_granges(bedfile, 'mm10', plot = FALSE)
    plot_karyogram(gr)
  
# Plot GRangesList
    flanks  <- up_flank(gr, stranded=FALSE)
    grlist <- GenomicRanges::GRangesList(sites = gr, flanks = flanks)
    plot_karyogram(grlist)
}
\seealso{
\code{\link{plot_intervals}}
}
