% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_bed_to_granges.R
\name{genes_to_granges}
\alias{genes_to_granges}
\alias{genefile_to_granges}
\title{Convert geneids into GRanges}
\usage{
genes_to_granges(geneids, txdb, complement = TRUE, plot = TRUE, verbose = TRUE)

genefile_to_granges(file, txdb, complement = TRUE, plot = TRUE)
}
\arguments{
\item{geneids}{Gene identifier vector}

\item{txdb}{\code{\link[GenomicFeatures]{TxDb-class}} or 
\code{\link[ensembldb]{EnsDb-class}}}

\item{complement}{TRUE (default) or FALSE: add complementary strand?}

\item{plot}{TRUE (default) or FALSE}

\item{verbose}{TRUE (default) or FALSE}

\item{file}{Gene identifier file (one per row)}
}
\value{
\code{\link[GenomicRanges]{GRanges-class}}
}
\description{
Convert geneids into GRanges
}
\examples{
# Entrez
#-------
    genefile <- system.file('extdata/SRF.entrez', package='multicrispr')
    geneids  <- as.character(read.table(genefile)[[1]])
    txdb     <- getFromNamespace('TxDb.Mmusculus.UCSC.mm10.knownGene',
                             'TxDb.Mmusculus.UCSC.mm10.knownGene')
    (gr <- genes_to_granges(geneids, txdb))
    (gr <- genefile_to_granges(genefile, txdb))

# Ensembl
#--------
    # txdb <- AnnotationHub::AnnotationHub()[["AH75036"]]
    # genefile <- system.file('extdata/SRF.ensembl', package='multicrispr')
    # geneids <- as.character(read.table(genefile)[[1]])
    # (gr <- genes_to_granges(geneids, txdb))
    # (gr <- genefile_to_granges(genefile, txdb))
}
\seealso{
\code{\link{char_to_granges}}, \code{\link{bed_to_granges}}
}
