% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preservation.R
\name{preservationComparisons}
\alias{preservationComparisons}
\title{Preservation comparisons}
\usage{
preservationComparisons(
  comparisonList,
  WGCNAlist,
  first,
  second,
  element,
  plot = FALSE,
  write = FALSE,
  alphaLevel = 0.05,
  nPermutations = 100
)
}
\arguments{
\item{comparisonList}{a list passed by the iterate function}

\item{WGCNAlist}{list of objects of type WGCNAobject}

\item{first}{index of first WGCNAobject}

\item{second}{index of second WGCNAobject}

\item{element}{element position in the comparison list (passed by iterate function)}

\item{plot}{generate plots?}

\item{write}{write results to file?}

\item{alphaLevel}{alpha level of significance for module-trait correlation}

\item{nPermutations}{number of permutations, defaults to 100}
}
\value{
a list of preservation comparisons results across levels 1, 2, 3
}
\description{
A high level function that performs a perservation comparison between two
WGCNAobjects in a WGCNAlist, usually supplied by iterate function
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
results = list()
iterate(astrocyte_networks[c("EAE", "WT")], 
  preservationComparisons, 
  write=FALSE, 
  plot=FALSE, 
  nPermutations=2)

}
\author{
Dario Tommasini
}
