% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreMotif.R
\name{calculatePvalue}
\alias{calculatePvalue}
\title{Calculate the significance of the matches for the reference and alternate alleles for the for their PWM}
\source{
H{\'e}l{\`e}ne Touzet and Jean-St{\'e}phane Varr{\'e} (2007) Efficient and accurate P-value computation for Position Weight Matrices.
 Algorithms for Molecular Biology, \bold{2: 15}.
}
\usage{
calculatePvalue(
  results,
  background = c(A = 0.25, C = 0.25, G = 0.25, T = 0.25),
  granularity = NULL,
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{results}{The output of \code{motifbreakR} that was run with \code{filterp=TRUE}}

\item{background}{Numeric Vector; the background probabilities of the nucleotides}

\item{granularity}{Numeric Vector; the granularity to which to round the PWM,
larger values compromise full accuracy for speed of calculation. A value of
\code{NULL} does no rounding.}

\item{BPPARAM}{a BiocParallel object see \code{\link[BiocParallel]{register}}
and see \code{getClass("BiocParallelParam")} for additional parameter
classes.  Try \code{BiocParallel::registered()} to see what's available and
for example \code{BiocParallel::bpparam("SerialParam")} would allow serial
evaluation.}
}
\value{
a GRanges object. The same Granges object that was input as \code{results}, but with
 \code{Refpvalue} and \code{Altpvalue} columns in the output modified from \code{NA} to the p-value
 calculated by \code{\link{TFMsc2pv}}. Additionally a \code{pvalueEffect} column that indicates "strong"
 when the lower p-value (between ref and alt) is an order of magnitude or more different from
 the higher p-value, otherwise weak.
}
\description{
Calculate the significance of the matches for the reference and alternate alleles for the for their PWM
}
\details{
This function is intended to be used on a selection of results produced by \code{\link{motifbreakR}}, and
this can be (although not always) a very memory and time intensive process if the algorithm doesn't converge rapidly.
}
\examples{
data(example.results)
rs1006140 <- example.results[example.results$SNP_id \%in\% "rs1006140"]
# low granularity for speed; 1e-6 or 1e-7 recommended for accuracy
rs1006140 <- calculatePvalue(rs1006140, BPPARAM=BiocParallel::SerialParam(), granularity = 1e-4)


}
\seealso{
See \code{\link{TFMsc2pv}} from the \pkg{TFMPvalue} package for
  information about how the p-values are calculated.
}
