% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPwmMatches.R
\name{getPwmMatches}
\alias{getPwmMatches}
\title{Find all PWM matches within an XStringSet}
\usage{
getPwmMatches(
  pwm,
  stringset,
  rc = TRUE,
  min_score = "80\%",
  best_only = FALSE,
  break_ties = c("all", "random", "first", "last", "central"),
  mc.cores = 1,
  ...
)
}
\arguments{
\item{pwm}{A Position Weight Matrix, list of PWMs or universalmotif list}

\item{stringset}{An XStringSet}

\item{rc}{logical(1) Also find matches using the reverse complement of pwm}

\item{min_score}{The minimum score to return a match}

\item{best_only}{logical(1) Only return the best match}

\item{break_ties}{Method for breaking ties when only returning the best match
Ignored when all matches are returned (the default)}

\item{mc.cores}{Passed to \link[parallel]{mclapply} if passing multiple PWMs}

\item{...}{Passed to \link[Biostrings]{matchPWM}}
}
\value{
A DataFrame with columns: \code{seq}, \code{score}, \code{direction}, \code{start},
\code{end}, \code{from_centre}, \code{seq_width}, and \code{match}

The first three columns describe the sequence with matches, the score of
the match and whether the match was found using the forward or reverse PWM.
The columns \code{start}, \code{end} and \code{width} describe the where the match was found
in the sequence, whilst \code{from_centre} defines the distance between the centre
of the match and the centre of the sequence being queried.
The final column contains the matching fragment of the sequence as an
\code{XStringSet}.

When passing a list of PWMs, a list of the above DataFrames will be returned.
}
\description{
Find all PWM matches within a set of sequences
}
\details{
Taking a set of sequences as an XStringSet, find all matches above the
supplied score (i.e. threshold) for a single Position Weight Matrix (PWM),
generally representing a transcription factor binding motif.
By default, matches are performed using the PWM as provided and the reverse
complement, however this can easily be disabled by setting \code{rc = FALSE}.

The function relies heavily on \link[Biostrings]{matchPWM} and
\link[IRanges]{Views} for speed.

When choosing to return the best match (\code{best_only = TRUE}), only the match
with the highest score is returned for each sequence.
Should there be tied scores, the best match can be chosen as either the first,
last, most central, all tied matches, or choosing one at random (the default).
}
\examples{
## Load the example PWM
data("ex_pfm")
esr1 <- ex_pfm$ESR1

## Load the example Peaks
data("ar_er_seq")

## Return all matches
getPwmMatches(esr1, ar_er_seq)

## Just the best match
getPwmMatches(esr1, ar_er_seq, best_only = TRUE)

## Apply multiple PWMs as a list
getPwmMatches(ex_pfm, ar_er_seq, best_only = TRUE)

}
