% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_de_summaries.R
\name{de_volcano}
\alias{de_volcano}
\title{Generates a volcano plot using ggplot2}
\usage{
de_volcano(
  res_de,
  mapping = "org.Mm.eg.db",
  logfc_cutoff = 0,
  FDR = 0.05,
  draw_FDR_line = FALSE,
  labeled_genes = 30
)
}
\arguments{
\item{res_de}{An object containing the results of the Differential Expression
analysis workflow (e.g. \code{DESeq2}, \code{edgeR} or \code{limma}).
Currently, this can be a \code{DESeqResults} object created using the \code{DESeq2}
framework.}

\item{mapping}{Which \code{org.XX.eg.db} package to use for annotation - select
according to the species}

\item{logfc_cutoff}{A numeric value that sets the cutoff for the xintercept
argument of ggplot. Defaults to 0.}

\item{FDR}{The pvalue threshold to us for counting genes as de
and therefore also where to draw the line in the plot. Default is 0.05}

\item{draw_FDR_line}{Logical, whether to draw a line at the p-value
corresponding to the specified FDR. Defaults to FALSE.}

\item{labeled_genes}{A numeric value describing the amount of genes to be
labeled. This uses the Top(x) highest differentially expressed genes}
}
\value{
A  \code{ggplot2} volcano plot object that can be extended upon by the
user
}
\description{
This function generates a base volcanoplot for differentially expressed genes
that can then be expanded upon using further ggplot functions.
}
\examples{
library("ggplot2")
library("RColorBrewer")
library("ggrepel")
library("DESeq2")
library("org.Hs.eg.db")

data(res_de_macrophage, package = "mosdef")

p <- de_volcano(res_macrophage_IFNg_vs_naive,
  logfc_cutoff = 1,
  labeled_genes = 20,
  mapping = "org.Hs.eg.db"
)

p
}
