% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_bicluster.R
\name{ensemble_biclusters}
\alias{ensemble_biclusters}
\title{Convert communities into ensemble biclusters}
\usage{
ensemble_biclusters(
  coms,
  bics,
  mat,
  row_threshold = 0.1,
  col_threshold = 0.1,
  threshold_sorted = FALSE
)
}
\arguments{
\item{coms}{A list of communities (\code{\link{bicluster_net}}s) as
outputted by \code{\link{get_louvain_communities}}.}

\item{bics}{The list biclusters that was used for calculation
with \code{\link{bicluster_network}}.}

\item{mat}{The numeric matrix, that was used for biclustering.}

\item{row_threshold}{Minimum fraction of biclusters of a community
in which a row needs to occur so that it will be part of the
outputted ensemble bicluster.}

\item{col_threshold}{Minimum fraction of biclusters of a community
in which a column needs to occur so that it will be part of the
outputted ensemble bicluster.}

\item{threshold_sorted}{Return the rows and columns in sorted by
decreasing fraction.}
}
\value{
A list of \code{\link{bicluster}} objects.
}
\description{
After calculation of communities with
the \code{\link{get_louvain_communities}} function, the result can be
converted into a list of \code{\link{bicluster}} objects with this function.
Only biclusters are returned which have a minimum dimension of 2x2.
}
\examples{
b <- list(bicluster(row=c(1,2,3,4), column=c(1,2,3,4)),
    bicluster(row=c(3,4,5,6), column=c(3,4,5,6)))
# m <- matrix(runif(100), nrow=10)
# tm = matrix(c(0,1,1,0), nrow=2)
# bn <- list(bicluster_net(adjacency_matrix=tm, threshold=.5))
# ensemble_biclusters(bn, b, m)

}
