% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAfeatures.R
\name{RNAfeatures}
\alias{RNAfeatures}
\title{Summarise the distribution of sRNA clusters across genomic features}
\usage{
RNAfeatures(
  data,
  annotation,
  repeats = NULL,
  repeat.type = NULL,
  promoterRegions = 1000,
  rmFeatures = NULL
)
}
\arguments{
\item{data}{data.frame; generated by \code{\link[=RNAimport]{RNAimport()}}}

\item{annotation}{path; URL or connection to a GFFFile object. A genome
reference annotation file (.gff/.gff1/.gff2/.gff3). Can be in compressed
format (gzip).}

\item{repeats}{path; URL or connection to a GFFFile object. A genome
reference annotation file, which only contains information on repeat
sequences in the genome (.gff/.gff1/.gff2/.gff3). By default, this is not
required, however if there is a specific repeats annotation file for the
genome it is suggested to supply it. Can be in compressed format (gzip).}

\item{repeat.type}{character; features type in \code{annotation} file to represent
repeats when \code{repeats} not supplied.}

\item{promoterRegions}{numeric; defines the upstream promoter region of
genes. Default is 1000, which refers to promoters set at 1Kb upstream of
genes}

\item{rmFeatures}{vector; type of genomic features to not consider such as
"gene" or "exon" etc.}
}
\value{
Returns a table containing the number and percentage of overlaps in
the supplied sRNA data set with genomic features within supplied annotation
and/or with repeats.
}
\description{
Calculates the number/proportion of genomic features within the
supplied annotations and calculates the number/proportion of sRNA clusters
which overlap with these genomic features.
}
\details{
\code{RNAfeatures} calculates the number/percentage of sRNA clusters which
overlap with genomic features based on their genomic coordinates.
}
\examples{
data("sRNA_data")
features <- RNAfeatures(data = sRNA_data,
                       annotation = system.file("extdata",
                       "reduced_chr2_Tomato.gff.gz", package="mobileRNA"))

}
\seealso{
\code{\link[=RNAmergeAnnotations]{RNAmergeAnnotations()}} to merge 2 GFF files into 1.
}
