% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAdifferentialAnalysis.R
\name{RNAdifferentialAnalysis}
\alias{RNAdifferentialAnalysis}
\title{Differential Analysis using \code{DESeq2} or \code{edgeR}}
\usage{
RNAdifferentialAnalysis(
  data,
  group,
  method = c("edgeR", "DESeq2"),
  dispersionValue = NULL
)
}
\arguments{
\item{data}{data.frame; originally generated by \code{\link[=RNAimport]{RNAimport()}}.}

\item{group}{character; the condition of each sample in the experimental
design, formatted in the order of samples shown in the \code{data} object from
left to right.}

\item{method}{character; method to undertaken differential analysis, choose
from methods of either \link[DESeq2:DESeq]{DESeq2::DESeq} or \link[edgeR:edgeR-package]{edgeR::edgeR}.
Must be stated as either "DESeq2" or "edgeR" in the function.}

\item{dispersionValue}{numeric; value to represent the dispersion value for
the \link[edgeR:edgeR-package]{edgeR::edgeR} method. Recommended for analysis in experiments without
biological replicates.}
}
\value{
Undertakes differential analysis, based on a specified method, and
appends the results to the supplied data frame. This includes:
\itemize{
\item Count mean
\item Log fold change
\item p-value
\item Adjusted p-value
\item Comparison order
}
}
\description{
\code{RNAdifferentialAnalysis} function computes the differential
analysis with \code{DESeq2} or \code{edgeR} of sRNA or mRNA data produced by the
\code{mobileRNA} package pipeline.
}
\details{
The user has the flexibility to choose the method that best suits
their data. In this function, the \code{DESeq2} method, calculates the
differentials based on the normalized count data based on the
size factors. Whereas the \code{edgeR} method, calculates normalization factors
estimates dispersion, and returns the common dispersion. After
normalization, the mean expression levels across samples are calculated, and
differential expression analysis is performed using the exact test
within groups, and the adjusted p-values are calculated using the
Benjamini-Hochberg method. Note that this function is only capable of
handling one replicate per condition with the \code{edgeR} method. This requires
setting a suitable dispersion value. The dispersion value is other wise known
as the common Biological squared coefficient of variation. See the
User’s Guide for the \code{edgeR} package for more details, \link[edgeR:edgeR-package]{edgeR::edgeR}.
}
\examples{
# load data 
data("sRNA_data")


# sample conditions.
groups <- c("Selfgraft", "Selfgraft", "Selfgraft", "Heterograft", "Heterograft", "Heterograft")


## Differential analysis: DEseq2 method
sRNA_DESeq2 <- RNAdifferentialAnalysis(data = sRNA_data,
                             group = groups,
                             method = "DESeq2" )


## Differential analysis: edgeR method
sRNA_edgeR <- RNAdifferentialAnalysis(data = sRNA_data,
                            group = groups,
                            method = "edgeR" )
}
