% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAattributes.R
\name{RNAattributes}
\alias{RNAattributes}
\title{Overlap the genomic features related to the sRNA clusters}
\usage{
RNAattributes(
  data,
  annotation,
  match = c("within", "genes"),
  bufferRegion = 1000
)
}
\arguments{
\item{data}{data.frame; originally generated by \code{\link[=RNAimport]{RNAimport()}} or
containing \code{chr}, \code{start} and \code{end} columns.}

\item{annotation}{path; URL, connection or GFFFile object. A genome
reference annotation file (.gff/.gff1/.gff2/.gff3).}

\item{match}{character; must be either  "within" or "genes". Where
"within" will return matches where the clusters can be found within any
annotation, while "genes" will return matches where the clusters can be found
within only genes.}

\item{bufferRegion}{numeric; a buffer region in base-pairs to extend the
start and end coordinates upstream and downstream respectively.}
}
\value{
Appends the attribute columns from the GFF file to the supplied data based on
overlapping genomic regions.
}
\description{
Overlap the genomic features related to the sRNA clusters
}
\details{
Based on genomic coordinates, assign sRNA clusters with matching annotation
information. This function can be used to find the genomic features from
which the sRNA clusters originate from. This includes genes or repetitive
regions. An additional buffer region at the start/end of the gene is added
to improve hits, and align with the assumptions about promoter regions.

It is important that any alteration which were made to the genome reference
(FASTA) used for aligment/clustering,  such as alterations to the chromosome
name, must be carried forth to the genome annotation file. See
\code{\link[=RNAmergeGenomes]{RNAmergeGenomes()}} and \code{\link[=RNAmergeAnnotations]{RNAmergeAnnotations()}} for
more information.
}
\examples{
 # load data 
data("sRNA_data")

attributes_df <- RNAattributes(data = sRNA_data,
                    annotation = system.file("extdata",
                    "prefix_reduced_chr2_Tomato.gff.gz", package="mobileRNA"),
                    match = "genes")

}
