% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_lfc.R
\name{estimate_log_fold_change}
\alias{estimate_log_fold_change}
\alias{estimate_log_fold_change,Moanin-method}
\title{Estimates log fold change}
\usage{
\S4method{estimate_log_fold_change}{Moanin}(
  object,
  contrasts,
  method = c("timecourse", "sum", "max", "timely", "abs_sum", "abs_squared_sum", "min")
)
}
\arguments{
\item{object}{An object of class \code{\link{Moanin}}, an object containing
all related information for time course data and the splines model that
will be used (if applicable). See \code{\link{create_moanin_model}} for
more details.}

\item{contrasts}{The contrasts to consider}

\item{method}{method for calculating the log-fold change. See details.}
}
\value{
A data.frame giving the estimated log-fold change for each gene
  (row). For all methods except for "timely", the data frame will consist of
  one column for each value of the argument \code{contrasts}. For "timely"
  there will be one column for each timepoint and contrast combination.
}
\description{
Estimates log fold change
}
\details{
The following methods exist for calculating the log-fold change
  between conditions over time (default is "timecourse"):
\itemize{
\item{\code{timely}}{The log-fold change for each individual timepoint
(\eqn{lfc(t)})}
\item{\code{timecourse}}{The average absolute per-week fold-change,
multiplied by the sign of the average per-week fold-change.}
\item{\code{sum}}{Sum of per-week log fold change, over all timepoints}
\item{\code{max}}{Max of per-week log fold change, over all timepoints}
\item{\code{abs_sum}}{Sum of the absolute value of the per-week log fold
change, over all timepoints}
\item{\code{abs_squared_sum}}{Sum of the square value of the per-week log
fold change, over all timepoint}
\item{\code{min}}{Min of per-week log fold change, over all timepoints}
}

If the user set \code{log_transform=TRUE} in the creation of the
  \code{Moanin} object, the data will be log transformed before calculating
  the fold-change.
}
\examples{
data(exampleData)
moanin <- create_moanin_model(data=testData,meta=testMeta)
estsTimely <- estimate_log_fold_change(moanin, 
   contrasts=c("K-C"), method="timely")
head(estsTimely)
estsTimecourse <- estimate_log_fold_change(moanin, 
   contrasts=c("K-C"),method="timecourse")
head(estsTimecourse)
}
