% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runAllMirnaModels.R
\name{runAllMirnaModels}
\alias{runAllMirnaModels}
\title{runAllMirnaModels runModel for all miRNAs}
\usage{
runAllMirnaModels(
  mirnas,
  DiffExpmRNA,
  DiffExpmiRNA,
  miranda_data,
  prob = 0.75,
  fdr_cutoff = 0.1,
  method = "fdr",
  cutoff = 0.05,
  all_coeff = FALSE,
  mode = NULL,
  family = glm_poisson(),
  scale = 1
)
}
\arguments{
\item{mirnas}{vector of unique miRNAs under investigation.}

\item{DiffExpmRNA}{deferentially/expressed mRNAs expression file.}

\item{DiffExpmiRNA}{deferentially/expressed miRNAs expression file.}

\item{miranda_data}{getInputSpecies output file ( use low filters).}

\item{prob}{user defined ratio for miRanda distribution for miRanda score selection default is 0.75.}

\item{fdr_cutoff}{cutoff for FDR selection default is 0.1.}

\item{method}{finInterResult miRNA and mRNA interrelation in two time points  results in a dataframe.}

\item{cutoff}{P-value cutoff of the model.}

\item{all_coeff}{if true only models with all negative coefficients will be selected if false at least one
negative coefficient should be in the model; default is TRUE.}

\item{mode}{model mode, default is Null, can be changed to "multi" and "inter".}

\item{family}{Default is glm_poisson(), for zero inflated negative binomial NB option use glm_zeroinfl(dist="negbin").}

\item{scale}{if normalized data (FPKM,RPKM,TPM,CPM), scale to 10 etc., however the higher you go on
#scale the less accuracy your p-value estimate will be.}
}
\value{
List of run models
}
\description{
This function runs the "runModel" function for all miRNAs and mRNA combinations of two and returns a
list with significant genes and FDR models
}
\examples{
mirnas <- c("ebv-mir-bart9-5p", "ebv-mir-bart6-3p")
x <- runAllMirnaModels(mirnas, mRNA, miRNA, miRanda,
    prob = 0.90, fdr_cutoff = 0.1, method = "fdr",
    all_coeff = TRUE, mode = "multi",
    family = glm_poisson(), scale = 100
)
}
\keyword{all_miRNAs}
\keyword{runAllMirnaModels}
