% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one2OneRnaMiRNA.R
\name{one2OneRnaMiRNA}
\alias{one2OneRnaMiRNA}
\title{one2OneRnaMiRNA correlation for miRNA and mRNA  using differntial expression
fold change and if/when available p-value}
\usage{
one2OneRnaMiRNA(
  files,
  gene_colname = "Gene",
  fc_colname = "FC",
  pval_colname = "pvalue",
  pthreshold = NULL
)
}
\arguments{
\item{files}{a list of dataframes either miRNAs or mRNAs from various time points.}

\item{gene_colname}{Default is a vector character of length 1 "Gene" user can alter if they choose
This column contains the gene names.}

\item{fc_colname}{Default "FC" is coloumn name for fold changes user can alter if they choose.}

\item{pval_colname}{Default is "pvalue" column name for p-values (in input).}

\item{pthreshold}{P-value threshold.}
}
\value{
Correlation dataframe
}
\description{
This function inputs accept a list of dataframes and returns an obj with
two dataframes called FC and p-value. FC with rownames == genes and columns are FC1, 2, 3, ...
(with fold-changes) - P-value with rownames == genes and columns are P1, 2, 3, ... (with p-values)
both data.frames have the same order dimensions.
}
\examples{
\donttest{
x <- one2OneRnaMiRNA(files)
}
}
\keyword{correlation}
