% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_pathways.R
\name{pathways2pdf}
\alias{pathways2pdf}
\title{Export augmented pathways to pdf}
\usage{
pathways2pdf(original_pathways, augmented_pathways, pathway_names, file)
}
\arguments{
\item{original_pathways}{A list of 
graph::graphNEL objects where each of the nodes is named with '<gene_ID>'.
Nodes of each graph::graphNEL represent the genes involved in the 
pathway and edges represent the biological interactions (activation or
repression) among those genes (activation or repression).}

\item{augmented_pathways}{A list of 
graph::graphNEL objects where each of the nodes is named with '<gene_ID>'.
Nodes of each graph::graphNEL represent genes 
and miRNAs involved in the 
pathway and edges represent the biological interactions (activation or 
repression) among them.}

\item{pathway_names}{A list of names of the pathways named by '<pathway_ID>'.}

\item{file}{The name of the file where the plots will be saved.}
}
\value{
A pdf file with the plottings of the augmented pathways.
}
\description{
This function creates a pdf file with plottings of a list of augmented 
pathways.
}
\examples{
data(augmented_pathways)
data(kegg_pathways)
data(names_pathways)
#The following instruction writes a pfd with three pathways
pathways2pdf(kegg_pathways[18:20],augmented_pathways[18:20],
             names_pathways[18:20], "three_pathways.pdf")
#The following instruction writes a pfd with all the pathways:
#NOTE: It may take time.
# pathways2pdf(kegg_pathways,augmented_pathways, 
#              names_pathways, "all_pathways.pdf")

}
\author{
Diana Diaz <dmd at wayne dot edu>
}

