% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_pathways.R
\name{integrate_mir}
\alias{integrate_mir}
\title{Produce augmented pathways}
\usage{
integrate_mir(original_pathways, targets_db)
}
\arguments{
\item{original_pathways}{A list of 
graph::graphNEL objects where each of the nodes is named with '<gene_ID>'.
Gene IDs used to identify the nodes must be the same gene IDs used to
identify the genes on the miRNA-target 
interactions data.frame, \code{targets_db}.
i.e. If the genes are identified by Entrez ID on the \code{original_pathways}
graph::graphNEL list, then the \code{targets_db} 
data.frame must identify the genes by Entrez ID as well.
Nodes of each graph::graphNEL represent the genes involved in the 
pathway and edges represent the biological interactions (activation or
repression) among those genes (activation or repression).}

\item{targets_db}{A data.frame with
columns: 'miRNA' which names the miRNAs
and 'Target.ID' which gives the gene ID of the target gene.
The Gene IDs used to identify the "Target.ID" column 
must be the same gene IDs used on the nodes of the \code{original_pathways}.
i.e. If the genes are identified by Entrez ID on the \code{original_pathways}
graph::graphNEL list, then the \code{targets_db} 
data.frame must identify the genes by Entrez ID as well.}
}
\value{
Gene signaling pathways augmented with miRNA interactions.
This is a list of 
graph::graphNEL objects where each of the nodes is named with '<gene_ID>'.
Nodes of each graph::graphNEL represent genes 
and miRNAs involved in the 
pathway and edges represent the biological interactions (activation or 
repression) among them.
}
\description{
This function takes each pathway of the input list of signaling pathways and
adds the miRNAs that are related to it.
}
\examples{
data(kegg_pathways)
data(mirTarBase)
kegg_pathways <- kegg_pathways[1:5] #delete this for augmenting all pathways.
augmented_pathways <- integrate_mir(kegg_pathways, mirTarBase)

}
\author{
Diana Diaz <dmd at wayne dot edu>
}

