% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsingFunctions.R
\name{readHlaAlignments}
\alias{readHlaAlignments}
\title{Read HLA allele alignments}
\usage{
readHlaAlignments(file, gene = NULL, trim = FALSE, unkchar = "")
}
\arguments{
\item{file}{Path to input file.}

\item{gene}{Character vector of length one specifying the name of a gene for
which alignment is required. See details for further explanations.}

\item{trim}{Logical indicating if alignment should be trimmed to start codon
of the mature protein.}

\item{unkchar}{Character to be used to represent positions with unknown
sequence.}
}
\value{
Matrix containing HLA allele alignments.

  Rownames correspond to allele numbers and columns to positions in the
  alignment. Sequences following the termination codon are marked as empty
  character (\code{""}). Unknown sequences are marked with a character of
  choice, by default \code{""}. Stop codons are represented by a hash (X).
  Insertion and deletions are marked with period (.).
}
\description{
\code{readHlaAlignments} read HLA allele alignments from file.
}
\details{
HLA allele alignment file should follow EBI database format, for details
see
\url{ftp://ftp.ebi.ac.uk/pub/databases/ipd/imgt/hla/alignments/README.md}.

All protein alignment files from the EBI database are shipped with the package.
They can be easily accessed using \code{gene} parameter. If \code{gene} is
set to \code{NULL}, \code{file} parameter is used instead and alignment is
read from the provided file. In EBI database alignments for DRB1, DRB3, DRB4
and DRB5 genes are provided as a single file, here they are separated.

Additionally, for the alleles without sequence defined in the original 
alignment files we have infered thier sequence based on known higher resolution
alleles.
}
\examples{
hla_alignments <- readHlaAlignments(gene = "A")

}
