% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformationFunctions.R
\name{hlaToAAVariation}
\alias{hlaToAAVariation}
\title{Generate amino acid variation matrix}
\usage{
hlaToAAVariation(hla_calls, indels = TRUE, unkchar = FALSE, as_df = TRUE)
}
\arguments{
\item{hla_calls}{HLA calls data frame, as returned by
\code{\link{readHlaCalls}} function.}

\item{indels}{Logical indicating whether indels should be considered when
checking variability.}

\item{unkchar}{Logical indicating whether unknown characters in the alignment
should be considered when checking variability.}

\item{as_df}{Logical indicating if data frame should be returned.
Otherwise a matrix is returned.}
}
\value{
Matrix or data frame containing variable amino acid positions.
  Rownames corresponds to ID column in \code{hla_calls}, and colnames to
  alignment positions. If no variation is found one column matrix filled with
  \code{NA}'s is returned.
}
\description{
\code{hlaToAAVariation} convert HLA calls data frame to a matrix of variable
 amino acid positions.
}
\details{
Variable amino acid positions are found by comparing elements of the
alignment column wise. Some of the values in alignment can be treated
specially using \code{indels} and \code{unkchar} arguments. Function
processes alignments for all HLA genes found in \code{hla_calls}.

Variable amino acid position uses protein alignments from
\href{ftp://ftp.ebi.ac.uk/pub/databases/ipd/imgt/hla/alignments/}{EBI database}.
}
\examples{
hlaToAAVariation(MiDAS_tut_HLA)

}
