% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformationFunctions.R
\name{getHlaFrequencies}
\alias{getHlaFrequencies}
\title{Calculate HLA allele frequencies}
\usage{
getHlaFrequencies(
  hla_calls,
  carrier_frequency = FALSE,
  compare = FALSE,
  ref_pop = c("USA NMDP African American pop 2", "USA NMDP Chinese",
    "USA NMDP European Caucasian", "USA NMDP Hispanic South or Central American",
    "USA NMDP Japanese", "USA NMDP North American Amerindian",
    "USA NMDP South Asian Indian"),
  ref = allele_frequencies
)
}
\arguments{
\item{hla_calls}{HLA calls data frame, as returned by
\code{\link{readHlaCalls}} function.}

\item{carrier_frequency}{Logical flag indicating if carrier frequency should
be returned.}

\item{compare}{Logical flag indicating if \code{hla_calls} frequencies
should be compared to reference frequencies given in \code{ref}.}

\item{ref_pop}{Character vector giving names of reference populations in
\code{ref} to compare with. Optionally vector can be named, then those
names will be used as population names.}

\item{ref}{Data frame giving reference allele frequencies. See
\code{\link{allele_frequencies}} for an example.}
}
\value{
Data frame with each row holding HLA allele, it's count and 
  frequency.
}
\description{
\code{getHlaFrequencies} calculates allele frequencies in HLA calls data
frame.
}
\details{
Both gene copies are taken into consideration for frequencies calculation,
\code{frequency = n / (2 * j)} where \code{n} is the number of allele
occurrences and \code{j} is the number of samples in \code{hla_calls}.
}
\examples{
getHlaFrequencies(MiDAS_tut_HLA)

}
