% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformationFunctions.R
\name{formatResults}
\alias{formatResults}
\title{Pretty format statistical analysis results helper}
\usage{
formatResults(
  results,
  filter_by = "p.value <= 0.05",
  arrange_by = "p.value",
  select_cols = c("term", "estimate", "std.error", "p.value", "p.adjusted"),
  format = c("html", "latex"),
  header = NULL,
  scroll_box_height = "400px"
)
}
\arguments{
\item{results}{Tibble as returned by \code{\link{runMiDAS}}.}

\item{filter_by}{Character vector specifying conditional expression used to
filter \code{results}, this is equivalent to \code{...} argument passed to
\code{\link[dplyr]{filter}}.}

\item{arrange_by}{Character vector specifying variable names to use for
sorting. Equivalent to \code{...} argument passed to
\code{\link[dplyr]{arrange}}.}

\item{select_cols}{Character vector specifying variable names that should be
included in the output table. Can be also used to rename selected
variables, see examples.}

\item{format}{String \code{"latex"} or \code{"html"}.}

\item{header}{String specifying header for result table. If \code{NULL} no header is added.}

\item{scroll_box_height}{A character string indicating the height of the table.}
}
\value{
Character vector of formatted table source code.
}
\description{
\code{formatResults} format statistical analysis results table to html or
latex format.
}
\examples{
\dontrun{
midas <- prepareMiDAS(hla_calls = MiDAS_tut_HLA,
                      colData = MiDAS_tut_pheno,
                      experiment = "hla_alleles")
object <- lm(disease ~ term, data = midas)
res <- runMiDAS(object, 
                experiment = "hla_alleles", 
                inheritance_model = "dominant")
formatResults(res,
              filter_by = c("p.value <= 0.05", "estimate > 0"),
              arrange_by = c("p.value * estimate"),
              select_cols = c("allele", "p-value" = "p.value"),
              format = "html",
              header = "HLA allelic associations")
}

}
