% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{filterByFrequency}
\alias{filterByFrequency}
\title{Filter MiDAS object by frequency}
\usage{
filterByFrequency(
  object,
  experiment,
  lower_frequency_cutoff = NULL,
  upper_frequency_cutoff = NULL,
  carrier_frequency = FALSE
)
}
\arguments{
\item{object}{\code{\link{MiDAS}} object.}

\item{experiment}{String specifying experiment.}

\item{lower_frequency_cutoff}{Number giving lower frequency threshold.
Numbers greater than 1 are interpreted as the number of feature occurrences,
numbers between 0 and 1 as fractions.}

\item{upper_frequency_cutoff}{Number giving upper frequency threshold.
Numbers greater than 1 are interpreted as the number of feature occurrences,
numbers between 0 and 1 as fractions.}

\item{carrier_frequency}{Logical flag indicating if carrier frequency should
be returned.}
}
\value{
Filtered \code{\link{MiDAS}} object.
}
\description{
Filter MiDAS object by frequency
}
\examples{
filterByFrequency(object = MiDAS_tut_object, 
                  experiment = "hla_alleles",
                  lower_frequency_cutoff = 0.05,
                  upper_frequency_cutoff = 0.95,
                  carrier_frequency = TRUE)

}
