% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psmelt2.R
\name{psmelt2}
\alias{psmelt2}
\title{Convert \code{\link{phyloseq-class}} object to long data format}
\usage{
psmelt2(x, sample.column = NULL, feature.column = NULL)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{sample.column}{A single character string specifying name
of the column to hold sample names.}

\item{feature.column}{A single character string specifying name
of the column to hold OTU or ASV names.}
}
\value{
A \code{tibble} in long format
}
\description{
An alternative to psmelt function from 
             \code{\link{phyloseq-class}} object.
}
\examples{
data("dietswap")
ps.melt <- psmelt2(dietswap, sample.column="SampleID", 
                   feature.column="Feature") 
head(ps.melt)                                         
}
\author{
Contact: Sudarshan A. Shetty \email{sudarshanshetty9@gmail.com}
}
\keyword{utilities}
