% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neat.R
\name{neat}
\alias{neat}
\title{Neatmap Sorting}
\usage{
neat(
  x,
  arrange = "both",
  method = "NMDS",
  distance = "bray",
  first.feature = NULL,
  first.sample = NULL,
  ...
)
}
\arguments{
\item{x}{A matrix or phyloseq object.}

\item{arrange}{Order 'features', 'samples' or 'both' (for matrices).
For matrices, it is assumed that the samples are on the columns and
features are on the rows. For phyloseq objects, features are the taxa of
the OTU table.}

\item{method}{Ordination method. Only NMDS implemented for now.}

\item{distance}{Distance method. See \code{\link{vegdist}} function from
the \pkg{vegan} package.}

\item{first.feature}{Optionally provide the name of the first feature to
start the ordering}

\item{first.sample}{Optionally provide the name of the first sample to
start the ordering}

\item{...}{Arguments to pass.}
}
\value{
Sorted matrix
}
\description{
Order matrix or phyloseq OTU table based on the neatmap
approach.
}
\details{
Borrows elements from the heatmap implementation in the
\pkg{phyloseq} package. The row/column sorting is not available there
as a separate function. Therefore I implemented this function to
provide an independent method for easy sample/taxon reordering for
phyloseq objects. The ordering is cyclic so we can start at any
point. The choice of the first sample may somewhat affect the overall
ordering
}
\examples{
data(peerj32)
# Take subset to speed up example
x <- peerj32$microbes[1:10,1:10]
xo <- neat(x, 'both', method='NMDS', distance='bray')

}
\references{
This function is partially based on code derived from the
\pkg{phyloseq} package. However for the original
neatmap approach for heatmap sorting, see (and cite):
Rajaram, S., & Oono, Y. (2010). NeatMap--non-clustering heat map
alternatives in R. BMC Bioinformatics, 11, 45.
}
\keyword{utilities}
