% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evenness.R
\name{evenness}
\alias{evenness}
\title{Evenness Index}
\usage{
evenness(x, index = "all", zeroes = TRUE, detection = 0)
}
\arguments{
\item{x}{A species abundance vector, or matrix (taxa/features x samples)
with the absolute count data (no relative abundances), or
\code{\link{phyloseq-class}} object}

\item{index}{Evenness index. See details for options.}

\item{zeroes}{Include zero counts in the evenness estimation.}

\item{detection}{Detection threshold}
}
\value{
A vector of evenness indices
}
\description{
Various community evenness indices.
}
\details{
By default, Pielou's evenness is returned.

The available evenness indices include the following:
1) 'camargo': Camargo's evenness (Camargo 1992)
2) 'simpson': Simpson’s evenness (inverse Simpson diversity / S)
3) 'pielou': Pielou's evenness (Pielou, 1966), also known as Shannon or
Shannon-Weaver/Wiener/Weiner evenness; H/ln(S). The Shannon-Weaver
is the preferred term; see A tribute to Claude Shannon (1916 –2001)
and a plea for more rigorous use of species richness,
species diversity and the ‘Shannon–Wiener’ Index.
Spellerberg and Fedor.
Alpha Ecology & Biogeography (2003) 12, 177–197
4) 'evar': Smith and Wilson’s Evar index (Smith & Wilson 1996)
5) 'bulla': Bulla’s index (O) (Bulla 1994)
  
Desirable statistical evenness metrics avoid strong bias towards very
large or very small abundances; are independent of richness; and range
within [0,1] with increasing evenness (Smith & Wilson 1996).
Evenness metrics that fulfill these criteria include at least camargo,
simpson, smith-wilson, and bulla. Also see Magurran & McGill (2011)
and Beisel et al. (2003) for further details.
}
\examples{
data(dietswap)
# phyloseq object
#d <- evenness(dietswap, 'pielou')
# matrix
#d <- evenness(abundances(dietswap), 'pielou')
# vector
d <- evenness(abundances(dietswap)[,1], 'pielou')

}
\references{
Beisel J-N. et al. A Comparative Analysis of Evenness Index Sensitivity.
Internal Rev. Hydrobiol. 88(1):3-15, 2003.
URL: \url{https://portais.ufg.br/up/202/o/2003-comparative_evennes_index.pdf}

Bulla L.
An  index  of  evenness  and  its  associated  diversity  measure.
Oikos 70:167--171, 1994

Camargo, JA. New diversity index for assessing structural alterations
in aquatic communities. Bull. Environ. Contam. Toxicol. 48:428--434, 1992.

Locey KJ and Lennon JT. Scaling laws predict global microbial diversity.
PNAS 113(21):5970-5975, 2016; doi:10.1073/pnas.1521291113.

Magurran AE, McGill BJ, eds (2011)
Biological Diversity: Frontiers in Measurement and Assessment
(Oxford Univ Press, Oxford), Vol 12.

Pielou, EC. The measurement of diversity in different types of
biological collections. Journal of Theoretical Biology 13:131--144, 1966.

Smith B and Wilson JB. A Consumer's Guide to Evenness Indices.
Oikos 76(1):70-82, 1996.
}
\seealso{
coverage, core_abundance, rarity, alpha
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
