% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divergence.R
\name{divergence}
\alias{divergence}
\title{Divergence within a Sample Group}
\usage{
divergence(x, y, method = "bray")
}
\arguments{
\item{x}{phyloseq object or a vector}

\item{y}{Reference sample. A vector.}

\item{method}{dissimilarity method: any method available via
phyloseq::distance function. Note that some methods
("jsd" and 'unifrac' for instance) do not work with the group divergence.}
}
\value{
Vector with dissimilarities; one for each sample, quantifying the
dissimilarity of the sample from the reference sample.
}
\description{
Quantify microbiota divergence (heterogeneity) within a
given sample set with respect to a reference.
}
\details{
Microbiota divergence (heterogeneity / spread) within a given sample
set can be quantified by the average sample dissimilarity or beta
diversity with respect to a given reference sample.

This measure is sensitive to sample size.
Subsampling or bootstrapping can be applied to equalize sample sizes
between comparisons.
}
\examples{
# Assess beta diversity among the African samples
# in a diet swap study (see \code{help(dietswap)} for references)
data(dietswap)
pseq <- subset_samples(dietswap, nationality == 'AFR')
reference <- apply(abundances(pseq), 1, median)
b <- divergence(pseq, reference, method = "bray")

}
\references{
To cite this R package, see citation('microbiome')
}
\seealso{
the vegdist function from the \pkg{vegan} package provides many
standard beta diversity measures
}
\author{
Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
