% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{coverage}
\alias{coverage}
\title{Coverage Index}
\usage{
coverage(x, threshold = 0.5)
}
\arguments{
\item{x}{A species abundance vector, or matrix (taxa/features x samples)
with the absolute count data (no relative abundances), or
\code{\link{phyloseq-class}} object}

\item{threshold}{Indicates the fraction of the ecosystem to be occupied by
the N most abundant species (N is returned by this function). If the
detection argument is a vector, then a data.frame is returned, one
column for each detection threshold.}
}
\value{
A vector of coverage indices
}
\description{
Community coverage index.
}
\details{
The coverage index gives the number of groups needed to
have a given proportion of the ecosystem occupied (by default 0.5 ie 50%).
}
\examples{
data(dietswap)
d <- coverage(dietswap, threshold=0.5)
}
\seealso{
dominance, alpha
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
