% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_abundance.R
\name{core_abundance}
\alias{core_abundance}
\title{Core Abundance}
\usage{
core_abundance(
  x,
  detection = 0.1/100,
  prevalence = 50/100,
  include.lowest = FALSE
)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{detection}{Detection threshold for absence/presence
(strictly greater by default).}

\item{prevalence}{Prevalence threshold (in [0, 1]). The
required prevalence is strictly greater by default. To include the
limit, set include.lowest to TRUE.}

\item{include.lowest}{Include the lower boundary of the detection and
prevalence cutoffs. FALSE by default.}
}
\value{
A vector of core abundance indices
}
\description{
Calculates the community core abundance index.
}
\details{
The core abundance index gives the relative proportion of the core
species (in [0,1]). The core taxa are defined as those that exceed the
given population prevalence threshold at the given detection level.
}
\examples{
data(dietswap)
d <- core_abundance(dietswap, detection=0.1/100, prevalence=50/100)
}
\seealso{
rarity
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
