% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot_alpha.R
\name{boxplot_alpha}
\alias{boxplot_alpha}
\title{Alpha Boxplot}
\usage{
boxplot_alpha(
  x,
  x_var = NULL,
  index = NULL,
  violin = FALSE,
  na.rm = FALSE,
  show.points = TRUE,
  zeroes = TRUE,
  element.alpha = 0.5,
  element.width = 0.2,
  fill.colors = NA,
  outlier.fill = "grey50"
)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{x_var}{Metadata variable to map to the horizontal axis.}

\item{index}{Alpha index to plot. See function \code{alpha}.}

\item{violin}{Use violin version of the boxplot}

\item{na.rm}{Remove NAs}

\item{show.points}{Include data points in the figure}

\item{zeroes}{Include zero counts in diversity estimation. Default is TRUE}

\item{element.alpha}{Alpha value for plot elements. Controls the 
transparency of plots elements.}

\item{element.width}{Width value for plot elements. Controls the 
transparency of plots elements.}

\item{fill.colors}{Specify a list of colors passed on to ggplot2 
\code{scale_fill_manual}}

\item{outlier.fill}{If using boxplot and and points together how to deal with 
outliers. See ggplot2 outlier.fill argument in 
geom_ elements.}
}
\value{
A \code{\link{ggplot}} plot object
}
\description{
Plot alpha index.
}
\details{
A simple wrapper to visualize alpha diversity index.
}
\examples{
data("dietswap")
p <- boxplot_alpha(dietswap, x_var = "sex", index="observed", violin=FALSE, 
                   na.rm=FALSE, show.points=TRUE, zeroes=TRUE, 
                   element.alpha=0.5, element.width=0.2, 
                   fill.colors= c("steelblue", "firebrick"),
                   outlier.fill="white")
p

}
\keyword{utilities}
