% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotGraph.R
\name{plotColGraph}
\alias{plotColGraph}
\alias{plotRowGraph}
\alias{plotGraph}
\alias{plotColGraph,ANY,SummarizedExperiment-method}
\alias{plotColGraph,SummarizedExperiment,missing-method}
\alias{plotRowGraph,ANY,SummarizedExperiment-method}
\alias{plotRowGraph,SummarizedExperiment,missing-method}
\title{Plotting igraph objects with information from a \code{SummarizedExperiment}}
\usage{
plotColGraph(x, y, ...)

plotRowGraph(x, y, ...)

\S4method{plotColGraph}{ANY,SummarizedExperiment}(
  x,
  y,
  show.label = show_label,
  show_label = FALSE,
  add.legend = add_legend,
  add_legend = TRUE,
  layout = "kk",
  edge.type = edge_type,
  edge_type = c("fan", "link", "arc", "parallel"),
  edge.colour.by = edge_colour_by,
  edge_colour_by = NULL,
  edge.width.by = edge_width_by,
  edge_width_by = NULL,
  colour.by = colour_by,
  colour_by = NULL,
  shape.by = shape_by,
  shape_by = NULL,
  size.by = size_by,
  size_by = NULL,
  assay.type = by_exprs_values,
  by_exprs_values = "counts",
  other.fields = other_fields,
  other_fields = list(),
  ...
)

\S4method{plotColGraph}{SummarizedExperiment,missing}(x, y, name = "graph", ...)

\S4method{plotRowGraph}{ANY,SummarizedExperiment}(
  x,
  y,
  show.label = show_label,
  show_label = FALSE,
  add.legend = add_legend,
  add_legend = TRUE,
  layout = "kk",
  edge.type = edge_type,
  edge_type = c("fan", "link", "arc", "parallel"),
  edge.colour.by = edge_colour_by,
  edge_colour_by = NULL,
  edge.width.by = edge_width_by,
  edge_width_by = NULL,
  colour.by = colour_by,
  colour_by = NULL,
  shape.by = shape_by,
  shape_by = NULL,
  size.by = NULL,
  assay.type = by_exprs_values,
  by_exprs_values = "counts",
  other.fields = other_fields,
  other_fields = list(),
  ...
)

\S4method{plotRowGraph}{SummarizedExperiment,missing}(x, y, name = "graph", ...)
}
\arguments{
\item{x, y}{a graph object and a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object or just a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}.
For the latter object a graph object must be stored in
\code{metadata(x)$name}.}

\item{...}{additional arguments for plotting. See
\code{\link{mia-plot-args}} for more details i.e. call
\code{help("mia-plot-args")}}

\item{show.label}{\code{Logical scalar}, \code{integer vector} or
\code{character vector}
If a \code{logical} scalar is given, should tip labels be plotted
or if a logical vector is provided, which labels should be shown? If an
\code{integer} or \code{character} vector is provided, it will be converted
to a logical vector. The \code{integer} values must be in the range of 1
and number of nodes, whereas the values of a \code{character} vector must
match values of a \code{label} or \code{name} column in the node data. In
case of a \code{character} vector only values corresponding to actual
labels will be plotted and if no labels are provided no labels will be
shown. (Default: \code{FALSE})}

\item{show_label}{Deprecated. Use \code{show.label} instead.}

\item{add.legend}{\code{Logical scalar}. Should legends be plotted?
(Default: \code{TRUE})}

\item{add_legend}{Deprecated. Use \code{add.legend} instead.}

\item{layout}{\code{Character scalar}. Layout for the plotted graph. See
\code{\link[ggraph:ggraph]{ggraph}} for details. (Default: \code{"kk"})}

\item{edge.type}{\code{Character scalar}. Type of edge plotted on the graph.
See \code{\link[ggraph:geom_edge_fan]{geom_edge_fan}} for details and other
available geoms. (Default: \code{"fan"})}

\item{edge_type}{Deprecated. Use \code{edge.type} instead.}

\item{edge.colour.by}{\code{Character scalar}. Specification of an edge
metadata field to use for setting colours of the edges.
(Default: \code{NULL})}

\item{edge_colour_by}{Deprecated. Use \code{edge.colour.by} instead.}

\item{edge.width.by}{\code{Character scalar}. Specification of an edge
metadata
field to use for setting width of the edges. (Default: \code{NULL})}

\item{edge_width_by}{Deprecated. Use \code{edge.width.by} instead.}

\item{colour.by}{\code{Character scalar}. Specification of a column metadata
field or a feature to colour graph nodes by, see the by argument in
\code{\link[scater:retrieveCellInfo]{?retrieveCellInfo}} for possible
values. (Default: \code{NULL})}

\item{colour_by}{Deprecated. Use \code{colour.by} instead.}

\item{shape.by}{\code{Character scalar}. Specification of a column metadata
field or a feature to shape graph nodes by, see the by argument in
\code{\link[scater:retrieveCellInfo]{?retrieveCellInfo}} for possible
values. (Default: \code{NULL})}

\item{shape_by}{Deprecated. Use \code{shape.by} instead.}

\item{size.by}{\code{Character scalar}. Specification of a column metadata
field or a feature to size graph nodes by, see the by argument in
\code{\link[scater:retrieveCellInfo]{?retrieveCellInfo}} for possible
values. (Default: \code{NULL})}

\item{size_by}{Deprecated. Use \code{size.by} instead.}

\item{assay.type}{\code{Character scalar}. or \code{integer scalar}.
Specifies which assay to obtain expression values from, for use in point
aesthetics - see the \code{exprs_values} argument in
\code{\link[scater:retrieveCellInfo]{?retrieveCellInfo}}.
(Default: \code{"counts"})}

\item{by_exprs_values}{Deprecated. Use \code{assay.type} instead.}

\item{other.fields}{Additional fields to include in the node information
without plotting them.}

\item{other_fields}{Deprecated. Use \code{other.fields} instead.}

\item{name}{\code{Character scalar}. If \code{x} is a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
the key for subsetting the \code{metadata(x)} to a graph object.
(Default: \code{"graph"})}
}
\value{
a \code{\link{ggtree}} plot
}
\description{
\code{plotGraph} plots an \code{igraph} object with additional information
matched from a \code{SummarizedExperiment} object for the nodes only.
Information on the edges have to provided manually.
}
\details{
Internally \code{tidygraph} and \code{ggraph} are used. Therefore, all
graph types which can be converted by \code{tidygraph::as_tbl_graph} can
be used.
}
\examples{
\donttest{
# data setup
library(mia)
data(GlobalPatterns)
data(col_graph)
data(row_graph)
data(row_graph_order)
metadata(GlobalPatterns)$col_graph <- col_graph

genus <- agglomerateByRank(GlobalPatterns,"Genus",na.rm=TRUE)
metadata(genus)$row_graph <- row_graph
order <- agglomerateByRank(genus,"Order",na.rm=TRUE)
metadata(order)$row_graph <- row_graph_order

# plot a graph independently
plotColGraph(col_graph,
             genus,
             colour.by = "SampleType",
             edge.colour.by = "weight",
             edge.width.by = "weight",
             show.label = TRUE)

# plot the graph stored in the object
plotColGraph(genus,
             name = "col_graph",
             colour.by = "SampleType",
             edge.colour.by = "weight",
             edge.width.by = "weight")


# plot a graph independently
plotRowGraph(row_graph,
             genus,
             colour.by = "Kingdom",
             edge.colour.by = "weight",
             edge.width.by = "weight")

# plot the graph stored in the object
plotRowGraph(genus,
             name = "row_graph",
             colour.by = "Phylum",
             edge.colour.by = "weight",
             edge.width.by = "weight")


# plot a graph independently
plotRowGraph(row_graph_order,
             order,
             colour.by = "Kingdom",
             edge.colour.by = "weight",
             edge.width.by = "weight")

# plot the graph stored in the object and include some labels
plotRowGraph(order,
             name = "row_graph",
             colour.by = "Phylum",
             edge.colour.by = "weight",
             edge.width.by = "weight",
             show.label = c("Sulfolobales","Spirochaetales",
                            "Verrucomicrobiales"))

# labels can also be included via selecting specific rownames of x/y
plotRowGraph(order,
             name = "row_graph",
             colour.by = "Phylum",
             edge.colour.by = "weight",
             edge.width.by = "weight",
             show.label = c(1,10,50))

# labels can also be included via a logical vector, which has the same length
# as nodes are present
label_select <- rep(FALSE,nrow(order))
label_select[c(1,10,50)] <-  TRUE
plotRowGraph(order,
             name = "row_graph",
             colour.by = "Phylum",
             edge.colour.by = "weight",
             edge.width.by = "weight",
             show.label = label_select)
}
}
