% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateSOI.R
\name{simulateSOI}
\alias{simulateSOI}
\title{Self-Organised Instability model (SOI) simulation}
\usage{
simulateSOI(
  n_species,
  x0 = NULL,
  names_species = NULL,
  carrying_capacity = 1000,
  A = NULL,
  k_events = 5,
  t_end = 1000,
  metacommunity_probability = runif(n_species, min = 0.1, max = 0.8),
  death_rates = runif(n_species, min = 0.01, max = 0.08),
  norm = FALSE
)
}
\arguments{
\item{n_species}{Integer: number of species}

\item{x0}{\code{Numeric scalar}. Specifies initial community abundances
If \code{NULL}, based on migration rates. (Default: \code{NULL})}

\item{names_species}{Character: names of species. If NULL,
\code{paste0("sp", seq_len(n_species))} is used.
(default: \code{names_species = NULL})}

\item{carrying_capacity}{\code{Integer scalar}. Indicates community size,
number of available sites (individuals). (Default: \code{1000})}

\item{A}{\code{Matrix}. Defines the positive and negative
interactions between n_species. If \code{NULL}, \code{powerlawA(n_species)} is used.
(Default: \code{NULL})}

\item{k_events}{\code{Integer scalar}. Indicates the number of transition
events that are allowed to take place during one leap. Higher values reduce
runtime, but also accuracy of the simulation. (Default: \code{5}).}

\item{t_end}{\code{Numeric scalar}. Specifies the end time of the simulation,
defining the modeled time length of the community. (Default: \code{1000})}

\item{metacommunity_probability}{\code{Numeric scalar}: Indicates the
normalized probability distribution of the likelihood that species from
the metacommunity can enter the community during the simulation.
(Default: \code{runif(n_species, min = 0.1, max = 0.8)})}

\item{death_rates}{\code{Numeric scalar}. Indicates the death rates of each species.
(Default: \code{runif(n_species, min = 0.01, max = 0.08)})}

\item{norm}{\code{Logical scalar}. Whether the time series should be
returned with the abundances as proportions (\code{norm = TRUE})
or the raw counts. (Default: \code{FALSE})}
}
\value{
\code{simulateSOI} returns a TreeSummarizedExperiment class object
}
\description{
Generate time-series with The Self-Organised Instability (SOI) model.
Implements a K-leap method for accelerating stochastic simulation.
}
\examples{
# Generate interaction matrix
A <- miaSim::powerlawA(10, alpha = 1.2)
# Simulate data from the SOI model
tse <- simulateSOI(
    n_species = 10, carrying_capacity = 1000, A = A,
    k_events = 5, x0 = NULL, t_end = 150, norm = TRUE
)

}
