% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateHubbell.R
\name{simulateHubbell}
\alias{simulateHubbell}
\title{Hubbell's neutral model simulation}
\usage{
simulateHubbell(
  n_species,
  M,
  carrying_capacity = 1000,
  k_events = 10,
  migration_p = 0.02,
  t_skip = 0,
  t_end,
  norm = FALSE
)
}
\arguments{
\item{n_species}{\code{Integer scalar}. Specifies the amount of
different species initially in the local community.}

\item{M}{\code{Integer scalar}. Specifies the amount of different
species in the metacommunity, including those of the local community}

\item{carrying_capacity}{\code{Integer scalar}. Indicates the fixed
amount of individuals in the local community. (Default: \code{1000})}

\item{k_events}{\code{Inteer scalar}. Indicates the fixed amount of
deaths of local community individuals in each generation (Default: \code{10})}

\item{migration_p}{\code{Numeric scalar}. The immigration rate; specifies
the probability that a death in the local community is replaced by a
migrant of the metacommunity rather than by the birth of a local
community member (Default: \code{0.02})}

\item{t_skip}{\code{Integer scalar}. Indicates the number of generations
that should not be included in the outputted species abundance matrix.
(Default: \code{0})}

\item{t_end}{\code{Integer scalar}. Indicates the number of simulations
to be simulated}

\item{norm}{\code{Logical scalar}. Whether the time series should be
returned with the abundances as proportions (\code{norm = TRUE}) or
the raw counts. (Default: \code{FALSE})}
}
\value{
\code{simulateHubbell} returns a TreeSummarizedExperiment class
object
}
\description{
Neutral species abundances simulation according to the Hubbell model.
}
\examples{
tse <- simulateHubbell(
    n_species = 8, M = 10, carrying_capacity = 1000, k_events = 50,
    migration_p = 0.02, t_end = 100
)

}
\references{
Rosindell, James et al. "The unified neutral theory of
biodiversity and biogeography at age ten." Trends in ecology & evolution
vol. 26,7 (2011).
}
