% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_FA}
\alias{module_FA}
\title{module_FA}
\usage{
module_FA(
  Modulelist,
  GOont = "BP",
  KEGGorganism = "hsa",
  Reactomeorganism = "human",
  OrgDb = "org.Hs.eg.db",
  padjustvaluecutoff = 0.05,
  padjustedmethod = "BH",
  Analysis.type = c("FEA", "DEA")
)
}
\arguments{
\item{Modulelist}{List object: a list of miRNA sponge modules.}

\item{GOont}{One of 'MF', 'BP', and 'CC' subontologies.}

\item{KEGGorganism}{Organism, supported organism listed 
in http://www.genome.jp/kegg/catalog/org_list.html.}

\item{Reactomeorganism}{Organism, one of 'human', 'rat', '
mouse', 'celegans', 'yeast', 'zebrafish', 'fly'.}

\item{OrgDb}{OrgDb}

\item{padjustvaluecutoff}{A cutoff value of adjusted p-values.}

\item{padjustedmethod}{Adjusted method of p-values, can select 
one of 'holm', 'hochberg', 'hommel', 'bonferroni', 'BH', 'BY', 
'fdr', 'none'.}

\item{Analysis.type}{The type of functional analysis selected, 
including 'FEA' (functional enrichment analysis) and 'DEA' 
(disease enrichment analysis).}
}
\value{
List object: a list of enrichment analysis results.
}
\description{
Functional analysis of miRNA sponge modules, including functional 
enrichment and disease enrichment analysis
}
\examples{
\dontrun{
data(BRCASampleData)
modulegenes_WGCNA <- module_WGCNA(ceRExp, mRExp)
# Identify miRNA sponge modules using sensitivity RV coefficient (SRVC)
miRSM_WGCNA_SRVC <- miRSM(miRExp, ceRExp, mRExp, miRTarget,
                        modulegenes_WGCNA, method = "SRVC",
                        SMC.cutoff = 0.01, RV_method = "RV")
miRSM_WGCNA_SRVC_genes <- miRSM_WGCNA_SRVC[[2]]
miRSM_WGCNA_SRVC_FEA <- module_FA(miRSM_WGCNA_SRVC_genes, Analysis.type = 'FEA')
miRSM_WGCNA_SRVC_DEA <- module_FA(miRSM_WGCNA_SRVC_genes, Analysis.type = 'DEA')
}

}
\references{
Zhang J, Liu L, Xu T, Xie Y, Zhao C, Li J, Le TD (2019). 
“miRspongeR: an R/Bioconductor package for the identification and analysis of 
miRNA sponge interaction networks and modules.” BMC Bioinformatics, 20, 235.

Zhang J, Liu L, Zhang W, Li X, Zhao C, Li S, Li J, Le TD. 
miRspongeR 2.0: an enhanced R package for exploring miRNA sponge regulation. 
Bioinform Adv. 2022 Sep 2;2(1):vbac063.

Yu G, Wang L, Han Y, He Q (2012). 
“clusterProfiler: an R package for comparing biological themes among gene clusters.” 
OMICS: A Journal of Integrative Biology, 16(5), 284-287.
}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
