% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{miRSM}
\alias{miRSM}
\title{miRSM}
\usage{
miRSM(
  miRExp = NULL,
  ceRExp,
  mRExp = NULL,
  miRTarget,
  CandidateModulegenes,
  typex = "standard",
  typez = "standard",
  nperms = 100,
  method = c("SCC", "SDC", "SRVC", "SM", "SSI", "SGCD", "SCRC"),
  num_shared_miRNAs = 3,
  pvalue.cutoff = 0.05,
  MC.cutoff = 0.8,
  SMC.cutoff = 0.1,
  RV_method = c("RV", "RV2", "RVadjMaye", "RVadjGhaziri"),
  BCmethod = "BCPlaid",
  CRC_method = c("Coxhead", "Rozeboom")
)
}
\arguments{
\item{miRExp}{NULL (default) or a SummarizedExperiment object. miRNA expression data: 
rows are samples and columns are miRNAs.}

\item{ceRExp}{A SummarizedExperiment object. ceRNA expression data: 
rows are samples and columns are ceRNAs.}

\item{mRExp}{NULL (default) or a SummarizedExperiment object. mRNA expression data: 
rows are samples and columns are mRNAs.}

\item{miRTarget}{A SummarizedExperiment object. Putative 
miRNA-target binding information.}

\item{CandidateModulegenes}{List object: a list of candidate 
miRNA sponge modules. Only for the SCC, SDC, SRVC, SSI, SGCD and SCRC methods.}

\item{typex}{The columns of x unordered (type='standard') or 
ordered (type='ordered'). Only for the SCC method.}

\item{typez}{The columns of z unordered (type='standard') or 
ordered (type='ordered'). Only for the SCC method.}

\item{nperms}{The number of permutations. Only for the SCC method.}

\item{method}{The method selected to identify miRNA sponge 
modules, including 'SCC', 'SDC', 'SRVC', 'SM', 'SSI', 'SGCD' and 'SCRC'.}

\item{num_shared_miRNAs}{The number of common miRNAs shared 
by a group of ceRNAs and mRNAs. Only for the SCC, SDC, SRVC, SSI, 
SGCD and SCRC methods.}

\item{pvalue.cutoff}{The p-value cutoff of significant sharing 
of common miRNAs by a group of ceRNAs and mRNAs or significant correlation.}

\item{MC.cutoff}{The cutoff of matrix correlation (canonical correlation, 
distance correlation and RV coefficient). Only for the SCC, SDC, SRVC, 
SSI, SGCD and SCRC methods.}

\item{SMC.cutoff}{The cutoff of sensitivity matrix correlation
(sensitivity canonical correlation, sensitivity distance correlation 
and sensitivity RV coefficient). Only for the SCC, SDC, SRVC, SSI, 
SGCD and SCRC methods when miRExp is not NULL.}

\item{RV_method}{the method of calculating RV coefficients. Select
one of 'RV', 'RV2', 'RVadjMaye' and 'RVadjGhaziri' methods.
Only for the SRVC method.}

\item{BCmethod}{Specification of the biclustering method, 
including 'BCBimax', 'BCCC', 'BCPlaid' (default), 'BCQuest', 
'BCSpectral', 'BCXmotifs'. Only for the SM method.}

\item{CRC_method}{the method of calculating matrix correlation. Select
one of 'Coxhead' and 'Rozeboom' methods.
Only for the SCRC method.}
}
\value{
List object: Group competition of miRNA sponge modules,
and miRNA sponge modules.
}
\description{
Identify miRNA sponge modules using sensitivity canonical correlation (SCC), 
sensitivity distance correlation (SDC),
sensitivity RV coefficient (SRVC), sensitivity similarity index (SSI), 
sensitivity generalized coefficient of determination (SGCD), 
sensitivity Coxhead's or Rozeboom's coefficient (SCRC), 
and sponge module (SM) methods.
}
\examples{
data(BRCASampleData)
modulegenes_igraph <- module_igraph(ceRExp[, seq_len(10)], 
    mRExp[, seq_len(10)])
# Identify miRNA sponge modules using sensitivity RV coefficient (SRVC)
miRSM_igraph_SRVC <- miRSM(miRExp, ceRExp, mRExp, miRTarget,
                        modulegenes_igraph, method = "SRVC",
                        SMC.cutoff = 0.01, RV_method = "RV")

}
\references{
Witten DM, Tibshirani R, Hastie T. A penalized matrix 
decomposition, with applications to sparse principal components 
and canonical correlation analysis. Biostatistics. 
2009, 10(3):515-34.

Szekely GJ, Rizzo ML. Partial distance 
correlation with methods for dissimilarities. Annals of Statistics. 
2014, 42(6):2382-2412.

Szekely GJ, Rizzo ML, Bakirov NK. 
Measuring and Testing Dependence by Correlation of Distances, 
Annals of Statistics, 2007, 35(6):2769-2794.

Robert P, Escoufier Y. A unifying tool for 
linear multivariate statistical methods: the RV-Coefficient. 
Applied Statistics, 1976, 25(3):257-265.

Smilde AK, Kiers HA, Bijlsma S, Rubingh CM, 
van Erk MJ. Matrix correlations for high-dimensional 
data: the modified RV-coefficient. Bioinformatics, 
2009, 25(3):401-405.

Maye CD, Lorent J, Horgan GW. 
Exploratory analysis of multiple omics datasets using 
the adjusted RV coefficient". Stat Appl Genet Mol Biol., 
2011, 10, 14.

EIGhaziri A, Qannari EM. Measures 
of association between two datasets; Application to sensory data, 
Food Quality and Preference, 2015, 40(A):116-124.

Indahl UG, Næs T, Liland KH. A similarity index for 
comparing coupled matrices. Journal of Chemometrics. 2018; 32:e3049.

Yanai H. Unification of various techniques of multivariate 
analysis by means of generalized coefficient of determination (GCD). 
Journal of Behaviormetrics, 1974, 1(1): 45-54.

Coxhead P. Measuring the relationship between two sets 
of variables. British journal of mathematical and statistical psychology, 
1974, 27(2): 205-212.

Rozeboom WW. Linear correlations between sets of variables.
Psychometrika, 1965, 30(1): 57-71.
}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
