% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRLAB.R
\name{MI}
\alias{MI}
\title{miRNA target prediction with  mutual information method}
\usage{
MI(datacsv, cause, effect, targetbinding = NA)
}
\arguments{
\item{datacsv}{the input dataset in csv format}

\item{cause}{the column range that specifies the causes (miRNAs), e.g. 1:35}

\item{effect}{the column range that specifies the effects (mRNAs), e.g. 36:2000}

\item{targetbinding}{the putative target, e.g. "TargetScan.csv". If targetbinding is not specified, only expression data is used.
If targetbinding is specified, the prediction results using expression data with be intersected with the interactions in the target binding file.}
}
\value{
A  matrix that includes the mutual information values. Columns are miRNAs, rows are mRNAs.
}
\description{
Calculate the mutual information of each pair of miRNA-mRNA,and return a matrix of mutual information values with columns are miRNAs and rows are mRNAs.
}
\examples{
dataset=system.file("extdata", "ToyEMT.csv", package="miRLAB")
results=MI(dataset, 1:3, 4:18) 
}
\references{
Moon, Y.I., Balaji, R., and Lall, U. (1995) Estimation of mutual information using kernel density estimators. Phys. Rev. E, 52, 2318 - 21.
}
