% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRLAB.R
\name{ImputeNormData}
\alias{ImputeNormData}
\title{Filter, impute, and normalise data.}
\usage{
ImputeNormData(dataset, r)
}
\arguments{
\item{dataset}{The input dataset in csv format. e.g. "EMT.csv"}

\item{r}{The rate threshold to filter the records (genes). Genes with more than r\% missing data will be removed.}
}
\value{
The processed dataset.
}
\description{
Remove the genes (rows) that have more than r\% of missing data;
use the impute package to fill in missing data, and finally normalise the data.
}
\examples{
dataset=system.file("extdata", "ToyEMT.csv", package="miRLAB")
impdata=ImputeNormData(dataset, 0.1)
}
\references{
1. Hastie T, Tibshirani R, Narasimhan B and Chu G. impute: Imputation for microarray data. R package version 1.42.0.

2. Smyth, G.K. (2005). Limma: linear models for microarray data. In Bioinformatics and computational biology solutions using R and Bioconductor (pp. 397-420). Springer New York.
}
