% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRLAB.R
\name{BordaTopk}
\alias{BordaTopk}
\title{Ensemble method for miRNA target prediction using Borda count election with topk targets}
\usage{
BordaTopk(listCEmatrices, topk)
}
\arguments{
\item{listCEmatrices}{a list of matrices that include the correlation/causal effects/scores resulting from a target prediction method}

\item{topk}{number of targets of a miRNA to be included in the calculation (Borda count election)}
}
\value{
a matrix of ranking scores (averaging all the rankings from different methods). Columns are miRNAs and rows are mRNAs
}
\description{
Use the Borda count election method to integrate the rankings from different miRNA target prediction methods, but only topk targets of each miRNA are included
in the calculation. The targets outside the topk will be assigned a large and fixed rank, e.g. number of genes in the dataset.
}
\examples{
dataset=system.file("extdata", "ToyEMT.csv", package="miRLAB")
ps=Pearson(dataset, cause=1:3, effect=4:18)
ida=IDA(dataset, cause=1:3, effect=4:18)
borda=BordaTopk(list(ps, ida), topk=10)
}
\references{
Le, T.D., Zhang, J., Liu, L., and Li, J. (2015) Ensemble Methods for miRNA Target Prediction from Expression Data, Plos ONE.
}
