\name{methylumi-package}
\alias{methylumi-package}
\alias{methylumi}
\docType{package}
\title{
Handle Illumina methylation data
}
\description{
This package contains a class structure for handling methylation data
from Illumina as well as utility functions for loading the data from
files generated by Illumina.  Normalization that attempts to correct for
dye bias is also included.

Important data classes include: \code{\linkS4class{MethyLumiSet}} and
\code{\linkS4class{MethyLumiQC}}, both of which are subsets of the
\code{\linkS4class{MethyLumi}} class, which is a subset of the
\code{\linkS4class{eSet}} class.

A worked example of the use of the package can be found by typing:
\code{openVignette()}.

A full listing of the available documentation can be obtained by typing
\code{help.start()} and selecting \code{methylumi} from the \code{Packages}
link or by typing \code{library(help="methylumi")}.

If you use the methylumIDAT function or its out-of-band preprocessing mechanisms in your work, a citation to the paper "Low-level processing of Illumina Infinium DNA methylation beadarrays" by TJ Triche, DJ Weisenberger, D Van Den Berg, KD Siegmund, and PW Laird, Nucleic acids research, 2013, would be appreciated.  
}
\details{
\tabular{ll}{
Package: \tab methylumi\cr
Type: \tab Package\cr
License: \tab GPL\cr
}
}
\author{
  Sean Davis <sdavis2@mail.nih.gov>
}
\references{
  \url{http://watson.nci.nih.gov/~sdavis/software/R}
}
\keyword{ IO }
\seealso{
\code{\link[Biobase:Biobase-package]{Biobase}}
}
