% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDNAmAge.R
\name{plotDNAmAge}
\alias{plotDNAmAge}
\title{Plot DNAm age estimation vs chronological age.}
\usage{
plotDNAmAge(x, y, tit = "Horvath's method", clock = "chronological", ...)
}
\arguments{
\item{x}{DNAm age estimation}

\item{y}{Chronological age}

\item{tit}{Plot title. Default is "Horvath's method".}

\item{clock}{Type of clock 'chronological' or 'GA',
default 'chronological'}

\item{...}{Other plot parameters for ggplot}
}
\value{
Plot with estimated DNAmAge
}
\description{
Plot DNAm age estimation vs chronological age.
}
\examples{

library(tidyverse)

path <- system.file("extdata", package = "methylclock")
covariates <- read_csv(file.path(
path,
"SampleAnnotationExample55.csv"
))
age <- covariates$Age
MethylationData <- get_MethylationDataExample()

age.example55 <- DNAmAge(MethylationData)
plotDNAmAge(age.example55$Horvath, age)
}
