% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylSig-package.R
\docType{package}
\name{methylSig}
\alias{methylSig}
\alias{methylSig-package}
\title{MethylSig: Differential Methylation Testing for WGBS and RRBS Data}
\description{
MethylSig is a package for testing for
   differentially methylated cytosines (DMCs) or regions (DMRs) in
   whole-genome bisulfite sequencing (WGBS) or reduced representation
   bisulfite sequencing (RRBS) experiments.  MethylSig uses a beta
   binomial model to test for significant differences between groups of
   samples. Several options exist for either site-specific or sliding
   window tests, and variance estimation.
}
\section{methylSig functions}{

filter_loci_by_coverage()
filter_loci_by_snps()
tile_by_regions()
tile_by_windows()
filter_loci_by_group_coverage()
diff_binomial()
diff_methylsig()
diff_methylsig_dss()
annotate_diff()
visualize_diff()
region_enrichment_diff()
}

\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/sartorlab/methylSig/issues}
}

}
\author{
\strong{Maintainer}: Raymond G. Cavalcante \email{rcavalca@umich.edu}

Authors:
\itemize{
  \item Yongseok Park \email{yongpark@pitt.edu}
}

}
\keyword{internal}
