\name{BSdata-class}
\docType{class}
\alias{BSdata-class}
\alias{BSdata}
\alias{show,BSdata-method}

\title{Class "BSdata"}
\description{ This class is used in the methylPipe library to point to a
  TABIX compressed file containing base-resolution DNA-methylation data
  and reference genome sequence}
\section{Objects from the Class}{
  Objects can be created by calls of the form \code{new("BSdata", ...)}
  or using the function BSdata(file, uncov, org) whose arguments are
  described in the next section Slots.
}
\section{Slots}{
  \describe{
    \item{\code{file}:}{Object of class \code{"character"} : the TABIX
      compressed file containing base-resolution DNA-methylation data.
      This file can be generated through the \code{\link{BSprepare}}
      function, and it must contain the following columns:
      chromosome assignment (in the form chr1, chr2...),
      genomic position (positive integer),
      strand (either - or +),
      methylation sequence context (either CG, CHG or CHH),
      number (>0) of sequencing reads with C calls at that genomic position,
      number of sequencing reads with T calls at that genomic position,
      binomial pvalue (-10*log10(pvalue)) for calling a mC at that position.}
    \item{\code{uncov}:}{Object of class \link{GRanges} : this
      \link{GRanges} object consists of the list of genomic regions with
      sequencing coverage information; this information is used to distinguish
      which methylation sites are unmethylated, but covered, from those
      that are missing data since they have no sequencing coverage. This
      object is automatically generated by the \code{\link{meth.call}}
      function while processing aligned files generated from the aligner.}
    \item{\code{org}:}{refrence genome of class BSgenome}
  }
}
\author{Mattia Pelizzola}
\seealso{
  \code{\link{BSprepare},\link{mCsmoothing}}
}
\examples{
require(BSgenome.Hsapiens.UCSC.hg18)
H1data <- system.file('extdata', 'H1_chr20_CG_10k_tabix_out.txt.gz', package='methylPipe')
uncov_GR <- GRanges(Rle('chr20'), IRanges(c(14350,69251,84185), c(18349,73250,88184)))
H1.db <- BSdata(file=H1data, uncov=uncov_GR, org=Hsapiens)
}
\keyword{classes}
