% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchControl.R
\docType{methods}
\name{assocComp}
\alias{assocComp}
\title{Associate principal components with sample annotations}
\usage{
assocComp(mBase, sampleAnnotation)
}
\arguments{
\item{mBase}{\code{\link{methylBase}} or \code{\link{methylBaseDB}} 
object with no NA values in the data part.}

\item{sampleAnnotation}{a data frame where columns are different 
annotations and 
                       rows are the samples, in the same order as 
                       in the methylBase object.}
}
\value{
a named list of principal component matrix (named 'pcs'),
% variation explained
        by principal compopents (named 'vars') and a p-value matrix 
        showing association
        p-values between sample annotations and principal components 
        (named 'association').
}
\description{
This function associates principal components with sample annotations
such as age, gender, batch_id. Can be used to detect which batch effects
are associated with the variation in the methylation values.
}
\examples{
data(methylKit)
sampleAnnotation=data.frame(batch_id=c("a","a","b","b"),age=c(19,34,23,40))
as=assocComp(mBase=methylBase.obj,sampleAnnotation)



}
\author{
Altuna Akalin
}
