% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceInternalMethods.R
\name{createDataStructure}
\alias{createDataStructure}
\title{Extract the number of conserved differentially methylated
elements in \code{GRanges}.}
\usage{
createDataStructure(interGenerationGR)
}
\arguments{
\item{interGenerationGR}{a \code{list} that contains the information for
all differentially methylated analysis done on each generation present in
the initial dataset. The \code{list} must contain the following elements:
\itemize{
\item\code{i2} a \code{list} of \code{GRanges} Each
\code{GRanges} represents the intersection of analysis results between two
consecutive generations. The first element represents the intersection
of the
first and second generations; the second element, the intersection of
the second and third generations; etc.. The number of entries depends
of the number of generations.
\item\code{iAll} a \code{list} of \code{GRanges}. Each \code{GRanges}
represents the intersection fo the analysis results between three or more
consecutive generations. The first element represents the
intersection of the first
three generations; the second element, the intersection of the first fourth
generations; etc..The number of entries depends of the number
of generations.
}}
}
\value{
a \code{list} containing the following elements:
\itemize{
\item\code{i2} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer}, the number of conserved
hyper differentially methylated sites between two consecutive generations.
The first element represents the intersection of the first and second
generations; the second element, the intersection of the second and third
generations; etc..
\item \code{HYPO} a \code{list} of \code{integer}, the number of conserved
hypo differentially methylated sites between two consecutive generations.The
first element represents the intersection of the first and second
generations; the second element, the intersection of the second and third
generations; etc..
}
\item\code{iAll} a \code{list} containing:
\itemize{
\item \code{HYPER} a \code{list} of \code{integer}, the number of conserved
hyper differentially methylated sites between three or more consecutive
generations. The first element represents the intersection of the first
three generations; the second element, the intersection of the first fourth
generations; etc..The number of entries depends of the number
of generations.
\item \code{HYPO} a \code{list} of \code{integer}, the number of conserved
hypo differentially methylated sites between three or more consecutive
generations. The first element represents the intersection of the first
three generations; the second element, the intersection of the first fourth
generations; etc..The number of entries depends of the number of
generations.
}
}
}
\description{
Extract the number of conserved differentially methylated
elements in \code{GRanges}. Each \code{GRanges}
is the result of one intersection between two or more consecutive
generations for one analysis done on all generations.
The hypo and hyper differentially methylated elements are counted
separatly.
}
\examples{

## Get the name of the directory where the file is stored
filesDir <- system.file("extdata", "TEST", package="methylInheritance")

## Load file containing results from a observation analysis
obsResults <- readRDS(file = paste0(filesDir,
    "/SITES/SITES_observed_results.RDS"))

## Create data structure using information form the observation analysis
formatedResults <- methylInheritance:::createDataStructure(obsResults)

}
\author{
Astrid Deschenes, Pascal Belleau
}
\keyword{internal}
