% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snp_removal.R
\name{remove_snps}
\alias{remove_snps}
\title{Removes CpG sites from the object if they overlap with common SNPs}
\usage{
remove_snps(
  m,
  populations = NULL,
  maf_threshold = 0.01,
  reduce_filtering = FALSE,
  forced = FALSE,
  keep = FALSE,
  n_chunks = 1,
  n_cores = 1
)
}
\arguments{
\item{m}{\code{\link{methrix}} object}

\item{populations}{Populations to use. Default is all.}

\item{maf_threshold}{The frequency threshold, above which the SNPs will be removed. Default is 0.01}

\item{reduce_filtering}{If TRUE, the SNPs with a MAF < 0.1 will be evaluated and only the highly variable ones will be removed.
Default FALSE.}

\item{forced}{the reduce_filtering is not recommended with less than 10 samples, but can be forced. Default is FALSE.}

\item{keep}{Do you want to keep the sites that were filtered out? In this case, the function will return with a list of wo methrix objects.}

\item{n_chunks}{Number of chunks to split the \code{\link{methrix}} object in case it is very large. Can only be used if input data is in HDF5 format. Default = 1.}

\item{n_cores}{Number of parallel instances. Can only be used if input data is in HDF5 format. \code{n_cores} should be less than or equal to \code{n_chunks}. If \code{n_chunks} is not specified, then \code{n_chunks} is initialized to be equal to \code{n_cores}. Default = 1.}
}
\value{
methrix object or a list of methrix objects
}
\description{
Removes CpG sites from the object if they overlap with common SNPs
}
\details{
Takes \code{\link{methrix}} object and removes common SNPs. SNPs overlapping with a CpG site and have a minor allele frequency (MAF)
above a threshold in any of the populations used will be selected and the corresponding CpG sites will be removed from the \code{\link{methrix}} object.
With the reduce_filtering option, SNPs with MAP < 0.1 will be further evaluated. If they show low variance in the dataset, there is probably no genotype
variability in the population, therefore the corresponding CpG site won't be removed. Please keep in mind that variance thresholds are
}
\examples{
data('methrix_data')
remove_snps(m = methrix_data, maf_threshold=0.01)
}
