% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methrix_plot.R
\name{plot_pca}
\alias{plot_pca}
\title{Plot PCA results}
\usage{
plot_pca(
  pca_res,
  m = NULL,
  col_anno = NULL,
  shape_anno = NULL,
  pc_x = "PC1",
  pc_y = "PC2",
  show_labels = FALSE
)
}
\arguments{
\item{pca_res}{Results from \code{\link{methrix_pca}}}

\item{m}{optinal methrix object. Default NULL}

\item{col_anno}{Column name of colData(m). Default NULL. Will be used as a factor to color different groups. Required \code{methrix} object}

\item{shape_anno}{Column name of colData(m). Default NULL. Will be used as a factor to shape different groups. Required \code{methrix} object}

\item{pc_x}{Default 'PC1'}

\item{pc_y}{Default 'PC2'}

\item{show_labels}{Default FLASE}
}
\value{
ggplot2 object
}
\description{
Plot PCA results
}
\examples{
data('methrix_data')
mpc = methrix_pca(methrix_data, do_plot = FALSE)
plot_pca(mpc)
}
