% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methrix_plot.R
\name{plot_coverage}
\alias{plot_coverage}
\title{Coverage QC Plots}
\usage{
plot_coverage(
  m,
  type = c("hist", "dens"),
  pheno = NULL,
  perGroup = FALSE,
  lim = 100,
  size.lim = 1e+06,
  col_palette = "RdYlGn"
)
}
\arguments{
\item{m}{Input \code{\link{methrix}} object}

\item{type}{Choose between 'hist' (histogram) or 'dens' (density plot).}

\item{pheno}{Column name of colData(m). Will be used as a factor to color different groups in the plot.}

\item{perGroup}{Color the plots in a sample-wise manner?}

\item{lim}{Maximum coverage value to be plotted.}

\item{size.lim}{The maximum number of observarions (sites*samples) to use. If the dataset is larger that this,
random sites will be selected from the genome.}

\item{col_palette}{Name of the RColorBrewer palette to use for plotting.}
}
\value{
ggplot2 object
}
\description{
Coverage QC Plots
}
\examples{
data('methrix_data')
plot_coverage(m = methrix_data)
}
