% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methrix_operations.R
\name{load_HDF5_methrix}
\alias{load_HDF5_methrix}
\title{Loads HDF5 methrix object}
\usage{
load_HDF5_methrix(dir = NULL, ...)
}
\arguments{
\item{dir}{The directory to read in from. Default NULL}

\item{...}{Parameters to pass to loadHDF5SummarizedExperiment}
}
\value{
An object of class \code{\link{methrix}}
}
\description{
Loads HDF5 methrix object
}
\details{
Takes  directory with a previously saved HDF5Array format \code{\link{methrix}} object and loads it
}
\examples{
data('methrix_data')
methrix_data_h5 <- convert_methrix(m=methrix_data)
target_dir = paste0(getwd(), '/temp1/')
save_HDF5_methrix(methrix_data_h5, dir = target_dir, replace = TRUE)
load_HDF5_methrix(target_dir)
}
