% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methrix_operations.R
\name{get_matrix}
\alias{get_matrix}
\title{Extract methylation or coverage matrices}
\usage{
get_matrix(m, type = "M", add_loci = FALSE, in_granges = FALSE)
}
\arguments{
\item{m}{\code{\link{methrix}} object}

\item{type}{can be \code{M} or \code{C}. Default 'M'}

\item{add_loci}{Default FALSE. If TRUE adds CpG position info to the matrix and returns as a data.table}

\item{in_granges}{Do you want the outcome in \code{GRanges}?}
}
\value{
Coverage or Methylation matrix
}
\description{
Extract methylation or coverage matrices
}
\details{
Takes \code{\link{methrix}} object and returns user specified \code{methylation} or \code{coverage} matrix
}
\examples{
data('methrix_data')
#Get methylation matrix
get_matrix(m = methrix_data, type = 'M')
#Get methylation matrix along with loci
get_matrix(m = methrix_data, type = 'M', add_loci = TRUE)
#' #Get methylation data as a GRanges object
get_matrix(m = methrix_data, type = 'M', add_loci = TRUE, in_granges=TRUE)
}
