% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{rangesRelativeToTSS}
\alias{rangesRelativeToTSS}
\title{Find locations of genomic regions relative to transcription start sites.}
\usage{
rangesRelativeToTSS(genomic_regions, tss_gr)
}
\arguments{
\item{genomic_regions}{A GRanges object.}

\item{tss_gr}{A GRanges object with transcription start sites. Each range should have width 1.
Upstream and downstream are relative to strand of tss_gr.}
}
\value{
A GRanges object where all regions have "relative" as the sequence names and
ranges are the location of TMRs relative to the TSS.
}
\description{
Find locations of genomic regions relative to transcription start sites.
}
\examples{
# Create query and subject GRanges 
genomic_regions <- GenomicRanges::GRanges(c("chr1:100-1000:+", "chr1:2000-3000:-"))
tss_gr <- GenomicRanges::GRanges(c("chr1:1500:+", "chr1:4000:-"))

# Calculate distances between query and subject
methodical::rangesRelativeToTSS(genomic_regions, tss_gr)
}
