% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmr_functions.R
\name{.find_tmrs_single}
\alias{.find_tmrs_single}
\title{Find TSS-Proximal Methylation-Controlled Regulatory Sites (TMRs)}
\usage{
.find_tmrs_single(
  correlation_df,
  offset_length = 10,
  p_value_threshold = 0.05,
  smoothing_factor = 0.75,
  min_gapwidth = 150,
  min_meth_sites = 5
)
}
\arguments{
\item{correlation_df}{A data.frame with correlation values between methylation sites and a transcript
or a path to an RDS file containing such a data.frame as returned by calculateMethSiteTranscriptCors.}

\item{offset_length}{Number of methylation sites added upstream and downstream of a central methylation site to form a window, resulting in a window size of 2*offset_length + 1.
Default value is 10.}

\item{p_value_threshold}{The p_value cutoff to use. Default value is 0.05.}

\item{smoothing_factor}{Smoothing factor for exponential moving average. Should be a value between 0 and 1 with higher
values resulting in a greater degree of smoothing. Default is 0.75.}

\item{min_gapwidth}{Merge TMRs with the same direction separated by less than this number of base pairs. Default value is 150.}

\item{min_meth_sites}{Minimum number of methylation sites that TMRs can contain. Default value is 5.}
}
\value{
A GRanges object with the location of TMRs.
}
\description{
Find TSS-Proximal Methylation-Controlled Regulatory Sites (TMRs)
}
\examples{
# Load methylation-transcript correlation results for TUBB6 gene
data("tubb6_cpg_meth_transcript_cors", package = "methodical")

# Find TMRs for 
tubb6_tmrs <- methodical:::.find_tmrs_single(correlation_df = tubb6_cpg_meth_transcript_cors)
print(tubb6_tmrs)

}
